#ifndef POINT_HPP
#define POINT_HPP
#include "types.h" //for windows.h RECT and HWND types

class Point
{
private:
	int _x,_y;
	friend class Rect;
public:
	Point():_x(0),_y(0){}
	Point(int x, int y):_x(x),_y(y){}
   Point(LPARAM lParam);
	~Point(){}
	void	Set(int x, int y){_x = x; _y = y;}
	int x()const {return _x;}
	int y()const {return _y;}
	Real Magnitude() const;
	Point operator=(const Point &p);
	BOOL operator==(const Point &p) const;
	Point operator+(const Point &p) const;
	Point operator-(const Point &p) const;
	Point& operator+=(const Point &p);
	Point& operator-=(const Point &p);
	Point& operator*=(Real r);
	friend Point operator*(Real r, const Point &p);
};


#endif //POINT_HPP
